import java.util.*;

public class Vuk {

	/**
	 * @param args
	 */
	
	// Zadatak vuk, HONI 2009-10 Kolo 2
	
	/* Vuk Vjekoslav se nalazi u sumi s mnogo lovaca. Svaki od lovaca krije se iza
		nekog stabla i vreba na vuka. Vjekoslav to zna, ali ne zna koliko lovaca ima u
		sumi i iza kojih se stabala oni nalaze. Stoga on u svakom trenutku yeli biti sto
		dalje od najblizeg stabla. Ipak, Vjekoslav zeli nekako doci do svoje jazbine.
		Sumu mozemo prikazati kao polje sa N redaka i M stupaca. Oznacimo na polju
		znakom '.' prazno sumsko polje, znakom '+' polje na kojem se nalazi stablo,
		znakom 'V' polje na kojem se nalazi Vjekoslav, a znakom 'J' polje na kojem se
		nalazi jazbina. Vjekoslav se moze iz polja u kojem se nalazi pomaknuti na polje
		koje se nalazi iznad, ispod, ljevo ili desno.
		Vjekoslava zanima koliko se najvise mora pribliziti nekom stablu da bi dosao do
		svoje jazbine. Ako se Vjekoslav nalazi na polju (R1, C1), a stablo na polju (R2,
		C2), udaljenost Vjekoslava od tog stabla iznosi: |R1-R2| + |C1-C2|
		Stablo ne zauzima cijelo polje pa Vjekoslav moze proci poljem na kojem se
		nalazi stablo, ali je tada njegova udaljenost od stabla 0.
		Pomozite Vjekoslavu i napisite program koji ce izracunati koliko se u najgorem
		slucaju Vjekoslav mora pribliziti stablu.
		ULAZNI PODACI
		U prvom retku nalazi se brojevi N i M (1 <= N, M <= 500), dimenzije sume.
		U sljedecih N redaka nalazi se po M znakova: '.' (tocka), '+', 'V', 'J'. U ulaznim
		podacima ce se nalaziti tocno jedan znak 'V' i 'J' te barem jedan znak '+'.
		IZLAZNI PODACI
		U prvom i jedinom retku ispisa potrebno je ispisati najveci moguci cijeli broj X,
		takav da Vjekoslav moze doci do jazbine tako da u svakom trenutku udaljenost
		izmedju njega i svakog stabla iznosi najmanje X.
		
		ulaz
		4 4
		+...
		....
		....
		V..J
		izlaz
		3
		
		
		ulaz
		4 5
		.....
		.+++.
		.+.+.
		V+.J+
		izlaz
		0
	 * 
	 * 
	 * Ovaj zadatak rjesavamo primjenom algoritma pretrazivanja. Za svako polje odredimo koliko je 
	 * udaljeno od najblizeg stabla. Svakom polju u kome je stablo pridruzimo 0, pa zatim sirimo dalje (red Q). 
	 * 
	 * Krenimo od polja na kojem se trenutno nalazi vuk. Sva njemu susjedna polja unosimo u sortiranu strukturu PQ
	 * (Priority Queue) u kojoj polja sortiramo prema udaljenosti od stabla. U svakom trenutku posjecujemo 
	 * polje koje se nalazi trenutno na najvecoj udaljenosti od stabla. Prilikom posjete nekog polja, sva polja 
	 * koja se nalaze oko njega a nisu vec u strukturi PQ se dodaju  u PQ. 
	 * Rjesenje za neko polje je minimum sljedecih vrijednosti: udaljenost tog polja do stabla ili rjesenja za polje 
	 * sa kojeg se doslo na to polje.
	 * Na ovaj nacin u O(n log n) slozenosti mozemo za svako polje izracunati trazenu informaciju. 
	 * 
	 */
	
	public static void vuk()
	{
		Queue<Trojka> Q = new LinkedList<Trojka>();
		PriorityQueue<Trojka> PQ = new PriorityQueue<Trojka>();
		Trojka V = new Trojka(-1,-1,-1), J =  new Trojka(-1,-1,-1);

		int[][] dr = { { 0, 1 }, { 1, 0 }, { -1, 0 }, { 0, -1 } }; // moguca pomjeranja
		int n, m;
		int [][] udalj = new int[ 505 ][ 505 ]; // matrica udaljenosti
		int [][] best = new int[ 505 ][ 505 ]; // matrica najboljih vrijednosti
		String[] mat = new String [ 505 ]; // ulazna matrica

		// Ucitavanje promjenljivih i zadavanje pocetnih vrijednosti 
		Scanner ulaz = new Scanner(System.in);
		n = ulaz.nextInt();
		m = ulaz.nextInt();
		String p = ulaz.nextLine(); // ucitavanje simbola "\n"
		for( int i = 0; i < n; ++i )
		{
			mat[i] = ulaz.nextLine();
			Arrays.fill(best[i], -1);
			Arrays.fill(udalj[i], -1);
		}	
		
		// Popunjavanje reda
		for( int i = 0; i < n; ++i )
			for( int j = 0; j < m; ++j ) 
			{
				if( mat[ i ].charAt(j) == '+' ) {
					udalj[ i ][ j ] = 0;
					Q.add( new Trojka(i,j,0) );
				}
				
				if( mat[ i ].charAt(j) == 'V' ) V = new Trojka ( i, j, -1 );
				if( mat[ i ].charAt(j) == 'J' ) J = new Trojka ( i, j, -1 );
			}
		
		System.out.printf("\n\nMatrica\n");
		for (int i = 0; i < n; i++)
			System.out.println(mat[i]);
		System.out.println();
		Trojka t1;
		
		while( !Q.isEmpty() ) {
			// Ovo je BFS algoritam sa prethodnog casa (zadatak sa skakacem). Jedina je razlika sto mozemo imati vise od jedne polazne tacke.
				int trow = Q.peek().x;
				int tcol = Q.peek().y;
				int level = Q.peek().z; 
				t1 = Q.remove();
				
				for( int i = 0; i < 4; ++i ) {
					int nrow = trow + dr[ i ][ 0 ];
					int ncol = tcol + dr[ i ][ 1 ];
					
					if( nrow < 0 || nrow >= n ) continue;
					if( ncol < 0 || ncol >= m ) continue;
					if( udalj[ nrow ][ ncol ] > -1 ) continue;
					
					udalj[ nrow ][ ncol ] = level + 1;
					Q.add( new Trojka( nrow, ncol , level + 1 ) );
				}
			}
			System.out.printf("\n\nUdalj\n");
			for (int i = 0; i < n; i++)
			{
				for (int j = 0; j < n; j++)
				{
					System.out.printf("%3d", udalj[i][j]);
				}
				System.out.printf("\n");
			}
			
			System.out.printf("\n\nBest\n");
			for (int i = 0; i < n; i++)
			{
				for (int j = 0; j < n; j++)
				{
					System.out.printf("%3d", best[i][j]);
				}
				System.out.printf("\n");
			}
				
			best[ V.x ][ V.y ] = udalj[ V.x ][ V.y ];
			PQ.offer( new Trojka ( V.x, V.y, best[ V.x ][ V.y ] ) ); // krecemo od pozicije na kojoj se trenutno nalazi vuk
			
			while( !PQ.isEmpty() ) {
				t1 = PQ.poll();
				int trow = t1.x;
				int tcol = t1.y;
				int D = t1.z;
				
				// U ovom algoritmu sada prvo obilazimo polja koja su na putanji na kojoj je vuk najudaljeniji od stabla
				for( int i = 0; i < 4; ++i ) {
					int nrow = trow + dr[ i ][ 0 ];
					int ncol = tcol + dr[ i ][ 1 ];
					
					if( nrow < 0 || nrow >= n ) continue;
					if( ncol < 0 || ncol >= m ) continue;
					if( best[ nrow ][ ncol ] > -1 ) continue;
					// if( udalj[ nrow ][ ncol ] == 0 ) continue;
					
					best[ nrow ][ ncol ] = Math.min( D, udalj[ nrow ][ ncol ] );
					PQ.offer(new Trojka( nrow, ncol, best[ nrow ][ ncol ] )  );
				}
			}
			
			System.out.printf("\n\nBest\n");
			for (int i = 0; i < n; i++)
			{
				for (int j = 0; j < n; j++)
				{
					System.out.printf("%3d", best[i][j]);
				}
				System.out.printf("\n");
			}
			
			System.out.printf( "%d\n", best[ J.x ][ J.y ] );
			
	}
	
	public static void main(String[] args) {
		vuk();
	}
}